//max 14
typedef struct prog_node/*#prog_node@*/
{
	/*0 4B */
	UINT32	tp_id				:16/*#masked : 1 | pos : 13@*/;/* MASK: 0xFFFF0000 */
	UINT32	video_pid			:13/*#name : Video Pid | pos : 4 @*/;
	UINT32	av_flag				: 1/*#name : Service Type | pos : 2 @*/;
	UINT32 level				: 2;
	/*1 4B*/
	UINT32	prog_number			:16/*#name : Service ID | pos : 3@*/;
	UINT32 service_type			: 8;
	UINT32 audio_channel   			: 2;
	UINT32 cur_audio			: 5;
	UINT32 provider_lock			: 1;

	/*2 4B*/				
	UINT32  fav_grp0	    		: 1/*#name : Favorite | pos :10 @*/;
	UINT32  fav_grp1	    		: 7/*#name :  Group| pos : 9 @*/;
//	UINT32 fav_grp2	    			: 1;
//	UINT32 fav_grp3	    			: 1;
//	UINT32 fav_grp4	    			: 1;
//	UINT32 fav_grp5	    			: 1;
//	UINT32 fav_grp6	    			: 1;
//	UINT32 fav_grp7	    			: 1;
	UINT32 pmt_pid				:13;
	UINT32 pmt_version			: 1;
	UINT32 user_modified_flag		: 1;
	UINT32 preset_flag 			: 2/*#name : Factory | pos : 12 @*/;
	UINT32 audio_count			: 7;

	/*3 4B*/
	UINT32	pcr_pid				:13/*#name : PCR Pid | pos : 8 @*/;
	UINT32 subtitle_pid			:13;
	UINT32 audio_volume			: 5;
	UINT32 lock_flag	    	: 1;

	UINT32  sat_id				:16/*#masked : 1 | pos : 14@*/;
	UINT32 teletext_pid			:13;
	UINT32 skip_flag			: 1;
	UINT32  ca_mode				: 1/*#name : Scramble | pos : 11 @*/;
	UINT32 audio_select			: 1;
	
	UINT16 audio_pid1/*#name : Audio Pid1 | pos : 5 @*/;
	UINT16 audio_pid2/*#name : Audio Pid2 | pos : 6 @*/;	
	UINT16 audio_pid3/*#name : Audio Pid3 | pos : 7 @*/;
	UINT16 audio_pid[13];
	
	UINT16 audio_lang1;
	UINT16 audio_lang2;
	UINT16 audio_lang3;
	UINT16 audio_lang[13];

	UINT8 service_name[36]/*#type : string | name :Service Name | pos : 1@*/;
	UINT8 service_provider_name[36];
}P_NODE;


//max 14
typedef struct default_prog_node /*#def_prog_node@*/
{
	/*0 4B */
	UINT32	tp_id				:16/*#masked : 1 | pos : 13@*/;/* MASK: 0xFFFF0000 */
	UINT32	video_pid			:13/*#name : Video Pid | pos : 4 @*/;
	UINT32	av_flag				: 1/*#name : Service Type | pos : 2 @*/;
	UINT32 level				: 2;
	/*1 4B*/
	UINT32	prog_number			:16/*#name : Service ID | pos : 3@*/;
	UINT32 service_type			: 8;
	UINT32 audio_count			: 2;
	UINT32 audio_channel   			: 2;
	UINT32 EIT_sch_flag			: 1;
	UINT32 cur_audio			: 2;
	UINT32 provider_lock			: 1;

	/*2 4B*/				
	UINT32  fav_grp0	    		: 1/*#name : Favorite | pos :10 @*/;
	UINT32  fav_grp1	    		: 7/*#name :  Group| pos : 9 @*/;
	//UINT32  fav_grp2	    		: 1;
	//UINT32  fav_grp3	    		: 1;
	//UINT32  fav_grp4	    		: 1;
	//UINT32  fav_grp5	    		: 1;
	//UINT32  fav_grp6	    		: 1;
	//UINT32  fav_grp7	    		: 1;
	UINT32 ci_data_id			:16;/* each bit indicate a CA System */
	UINT32 lock_flag	    		: 1;
	UINT32  preset_flag 			: 2/*#name : Factory | pos : 12 @*/;
	UINT32 	audio_volume			: 5;
	/*3 4B*/
	UINT32	pcr_pid				:13/*#name : PCR Pid | pos : 8 @*/;
	UINT32 subtitle_pid			:13;
	UINT32 pmt_version			: 5;	/* this value is not countable, since it will rewind */
	UINT32 EIT_pf_flag			: 1;

	UINT32  sat_id				:16/*#masked : 1 | pos : 14@*/;
	UINT32 teletext_pid			:13;
	UINT32 skip_flag			: 1;
	UINT32  ca_mode				: 1/*#name : Scramble | pos : 11 @*/;
	UINT32 audio_select			: 1;
	
	/*LJF 2006/10/08 add the following two field according to ALI*/
	UINT16 pmt_pid;
	UINT16 reserve;
	
	UINT16  audio_pid1/*#name : Audio Pid1 | pos : 5 @*/;
	UINT16  audio_pid2/*#name : Audio Pid2 | pos : 6 @*/;
	UINT16  audio_pid3/*#name : Audio Pid3 | pos : 7 @*/;
	UINT16 audio_lang1;
	UINT16 audio_lang2;
	UINT16 audio_lang3;
	UINT8 service_name [36]/*#type : string | name :Service Name | pos : 1@*/;
	UINT8 service_provider_name[36];
}P_DEFAULT_NODE;

//max 5
typedef struct tp_node/*#tp_node@*/
{	
	/* 0 4B */
	UINT32	tp_id				:16/*#pos : 1@*/;
	UINT32 reserved				:12;
	UINT32 universal_22k_option		: 1;
	UINT32 preset_flag			: 2;
	UINT32 Big5_indicator			: 1; /* for some TAIWAN channels */
	
	/* 1 4B */
	UINT32	sat_id				:16/*#pos : 4@*/;
	UINT32 usage_status			: 1;
	UINT32 nit_pid				:13;
	UINT32 pol				: 2/*#pos : 5@*/;

	/* 2 4B */
	UINT32 frq/*#pos : 2@*/;

	/* 3 4B */
	UINT32 sym				:28/*#pos : 3@*/;
	UINT32 FEC_inner			: 4;

	/* 4 4B */
	UINT32 t_s_id				:16;
	UINT32 network_id			:16;
}T_NODE;

//max 12
typedef struct sat_node/*#sat_node@*/
{
	/* 0 4B */
	UINT32	sat_id				:16/*#pos : 2@*/;
	UINT32	k22				: 1/*#pos : 9@*/;
	UINT32	DiSEqC_type			: 3/*#pos : 11@*/;/* 1/4,1/8,1/16 */
	UINT32  DiSEqC_port 			: 4/*#pos : 12@*/;
	UINT32 selected_flag			: 1;
	UINT32 v12				: 1/*#pos : 8@*/;
	UINT32	reserved_1		: 6;


	/* 1 4B */
	UINT32	lnb_power			: 1;
	UINT32  lnb_type			: 7/*#pos : 3@*/;	/*0: not DiSEqC LNB 
							  1:Universal Local freq DiSEqC LNB
							  2:DiSEqC LNB Hi local freq
							  3:DiSEqC LNB lo local freq*/	
	UINT32	lnb_high			:16/*#pos : 4@*/;
	UINT32 DiSEqC11_type		: 3;/* 1/4,1/8,1/16 */
	UINT32 DiSEqC11_port 		: 4;
	UINT32  reserved_2			: 1;
	
	/* 2 4B */
	UINT32	positioner_type			: 3;	/*0 no positioner 1 positioner support*/
	UINT32  pol				: 2;    /* 0: auto,1: H,2: V */
	UINT32  toneburst			: 3/*#pos : 10@*/;	/* 0: off, 1: A, 2: B */	
	UINT32	lnb_low				:16/*#pos : 5@*/;
	UINT32  reserved_3			:8;

	/* 3 4B */
	UINT32 	position			: 8/*#pos : 6@*/;	
	UINT32	sat_orbit 			:24/*#pos : 7@*/;
	UINT8 sat_name[36]/*#name :satname | type :string | pos : 1@*/;
}S_NODE;